unit PHCustom;
                       {Copyright  1998 by Igor Glukhov}
                           {Project name: ProHelp}

{===============================================================================

 You may customize "implementation" section of this unit on own taste.
 In order to recompile this unit follow the instructions listed bellow.

                             Delphi 2.xx
 * In the IDE menu choose "Component|Rebuild Library".

                             Delphi 3.xx
 * In the IDE menu choose "File|Open..." and open the igProHelp.dpk file
   to display "Package..." dialog box.
 * Click the ""Compile" speed button and then close the "Package..." dialog box.

                            C++Builder 1.0
 * Run the custom.bat file located in the ProHelp's directory.
   In order the custom.bat file work properly, dcc32.exe must be in the search
   path. Dcc32.exe is located in the BIN directory of C++Builder.
 * In the IDE menu choose "Component|Rebuild Library".

                            C++Builder 3.0
 * In the IDE menu choose "File|Open Project..." and open the igProHelp.bpk
   make file.
 * In the IDE menu choose "Project|Build igProHelp.bpk".

 =============================================================================}

interface
uses
  SysUtils, Classes;
type

TStdHints = class(TObject)
   public
 // Non client window area hints
     NCCloseBtnH,
     NCRestoreBtnH,
     NCCtrlMenuIconH,
     NCMinBtnH,
     NCMaxBtnH,
     NCNormWndTitleH,
     NCMaxWndTitleH,
     NCMinWndTitleH,
     NCPopUpWndTitleH,
     NCHScroolH,
     NCVSCroolH,
     NCHlpBtnH,
     NCEdgeH,
     NCCornerH,
// Hints of the window control menu items
     CMMaximizeH,
     CMMoveH,
     CMRestoreH,
     CMSizeH,
     CMMinimizeH,
     CMCloseH,
     CMNextWindowH,
     CMSelfH, //Menu icon hint
// Edit control menu  hints
     EMUndoH,
     EMCutH,
     EMCopyH,
     EMPasteH,
     EMDeleteH,
     EMSelectAllH,
// igHelpButton hints
     AppHBUpStateH,
     DlgHBUpStateH,
     HBDownStateH,
// "What's This?" button hints
     HMObjRBtnHelpH,
     //HMMenuRBtnHelpH,
     //HMMenuItemRBtnHelpH,
// Help mode's hints
     HMAppHelpModeH,
     HMDlgHelpModeH,
//"What's this?" command of the "Help" menu
     HMHelpModeCmdH,
// Standard controls
     StdBtnOkH,
     StdBtnCancelH,
     StdBtnHelpH,
     StdBtnApplyH,
     StdStatusBarH,
// "Window" menu items of the MDI application
     WMUncheckedWndH,         // Inactive window from the window list
     WMCheckedWndH,           // Active window from the window list
     WMMoreWindowsH: string;  //"More Window ..." command
   public
     constructor Create; virtual;
end;

TStdCaptions = class(TPersistent)
  private
    FOKButton,
    FCancelButton,
    FHelpButton,
    FApplyButton,
    FWhatIsThisCmd: string;
  published
    property OKButton: string read FOKButton write FOKButton;
    property CancelButton: string read FCancelButton write FCancelButton;
    property HelpButton: string read FHelpButton write FHelpButton;
    property ApplyButton: string read FApplyButton write FApplyButton;
    property WhatIsThisCmd: string read FWhatIsThisCmd write FWhatIsThisCmd;
  public
    constructor Create; virtual;
end;

implementation

constructor TStdHints.Create;
begin
  NCCloseBtnH     := 'Click to close the window';
  NCRestoreBtnH   := 'Click to restore the window previous size and location';
  NCCtrlMenuIconH := 'Click to popup control menu';
  NCMinBtnH       := 'Click to reduce the window to an icon';
  NCMaxBtnH       := 'Click to enlarge the window to full size';
  NCNormWndTitleH := 'Drag to move the window, double-click to enlarge its to full size';
  NCMaxWndTitleH  := 'Double-click to restore the window previous size and location';
  NCMinWndTitleH  := 'Drag to move the window, double-click to restore its previous size and location';
  NCPopUpWndTitleH:= 'Drag the title bar to move the window';
  NCHScroolH      := 'To scroll window horizontally drag the box or click the arrows';
  NCVSCroolH      := 'To scroll window vertically drag the box or click the arrows';
  NCHlpBtnH       := 'Click and then choose the object to receive the help on';
  NCEdgeH         := 'Drag the edge to resize the window';
  NCCornerH       := 'Drag the corner to resize the window';
  CMMaximizeH     := 'Enlarges the window to full size|This command is not available because the window is zoomed to it maximum size';
  CMMoveH         := 'Changes the window position|This command is not available because the window is zoomed to it maximum size';
  CMRestoreH      := 'Restores the window previous size and location|This command is not available because the window is not maximized or minimized';
  CMSizeH         := 'Changes the window size|This command is not available because the window is zoomed to it maximum size';
  CMMinimizeH     := 'Reduces the window to an icon|This command is not available because the window is minimized';
  CMCloseH        := 'Closes the window';
  CMNextWindowH   := 'Makes the next child window in the window sequence the active window';
  CMSelfH         := 'The window control menu commands';
  EMUndoH         := 'Undoes the last action|This command is not available because there is no last action to undo';
  EMCutH          := 'Cuts the selection and puts it on the Clipboard|This command is not available because no text is selected';
  EMCopyH         := 'Copies the selection to the Clipboard|This command is not available because no text is selected';
  EMPasteH        := 'Inserts the Clipboard contents at the insertion point|This command is not available because the Clipboard is empty or not valid';
  EMDeleteH       := 'Deletes the selection|This command is not available because no text is selected';
  EMSelectAllH    := 'Selects the entire contents|This command is not available because there is no contents to select';
  HBDownStateH    := 'Click to interrupt help mode';
  AppHBUpStateH   := 'Context Sensitive Help|Click to get help on command or screen region, double-click to display the contents window of the online help';
  DlgHBUpStateH   := 'Context Sensitive Help|Click to get help on command or screen region, double-click to display the help window for the dialog';
  HMObjRBtnHelpH  := 'Click ''What''s This?'' button to get help on the selected object';
  //HMMenuRBtnHelpH := 'Click ''What''s This'' button to get help on ''%s'' menu';
  //HMMenuItemRBtnHelpH := 'Click ''What''s This'' button to get help on ''%s'' command';
  HMAppHelpModeH  := 'Choose a command or click an object to get help on';
  HMDlgHelpModeH  := 'Click an object to get help on';
  HMHelpModeCmdH  := 'Lets you get help on command or screen region';
  StdBtnOkH       := 'Applies changes you have made and then closes this dialog box';
  StdBtnCancelH   := 'Closes this dialog box without saving any changes you have made';
  StdBtnHelpH     := 'Display contextual Help for this dialog box';
  StdBtnApplyH    := 'Saves all the changes you have made without closing this dialog box';
  StdStatusBarH   := 'Status Bar displays information about a window objects, menu commands and operations in progress';
  WMMoreWindowsH  := 'Displays the list of all open windows';
  WMCheckedWndH   := '''%s'' is currently active window';
  WMUncheckedWndH := 'Switches to ''%s'' window';
end;

constructor TStdCaptions.Create;
begin
 CancelButton       := 'Cancel';
 OKButton           := 'OK';
 HelpButton         := 'Help';
 ApplyButton        := 'Apply';
 WhatIsThisCmd      := '&What''s This?';
end;

end.
